package org.retentionprediction;

import javax.swing.JPanel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Rectangle;
import javax.media.opengl.*;
import java.awt.Point;
import javax.swing.JButton;
import java.awt.Dimension;
import java.util.Vector;
import java.util.Arrays;

import javax.swing.BorderFactory;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

import java.awt.Font;

import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

import javax.swing.JToggleButton;
import javax.swing.ImageIcon;
import javax.help.*;

import org.retentionprediction.TopPanel.JChemicalTable;
import org.jdesktop.swingx.*;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;

import javax.swing.JLabel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import java.awt.event.KeyEvent;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import javax.media.opengl.GLCapabilities;
import javax.swing.SwingConstants;

public class TopPanel extends JPanel
{
	private static final long serialVersionUID = 1L;
	
	public GraphControl m_GraphControl = null;
	//public DefaultTableColumnModelExt tabModel;
	
	public Vector<String> vectColumnNames = new Vector<String>();  //  @jve:decl-index=0:
	public Vector<Vector<String>> vectChemicalRows = new Vector<Vector<String>>();  //  @jve:decl-index=0:
	
	private JPanel jpanelSimulatedChromatogram = null;
	public JPanel jpanelStep1 = null;
	private JLabel jlblStationaryPhase = null;
	public JComboBox jcboStationaryPhase = null;
	private JLabel jlblInitialSolventComposition = null;
	public JTextField jtxtInitialSolventComposition = null;
	private JLabel jlblFinalSolventComposition = null;
	public JTextField jtxtFinalSolventComposition = null;
	private JLabel jlblGradientTime = null;
	public JTextField jtxtGradientTime = null;
	private JLabel jLabel = null;
	private JLabel jLabel1 = null;
	private JLabel jLabel2 = null;
	private JLabel jlblFlowRate = null;
	public JTextField jtxtFlowRate = null;
	private JLabel jLabel21 = null;
	private JPanel jpanelStep2 = null;
	private JPanel jpanelStep3 = null;
	private JScrollPane jScrollPane = null;
	public JTable jTable = null;

	public JPanel jpanelStep4 = null;

	private JScrollPane jScrollPane1 = null;

	public JTable jtableMeasuredRetentionTimes = null;
	
	public SpecialTableModel tmSelectCompounds;
	public SpecialTableModel tmMeasuredRetentionTimes;

	public JPanel jpanelFlowProfile = null;

	public GraphControl m_GraphControlFlow = null;

	public GLCapabilities capsFlow = null;

	public JButton jbtnNextStep = null;

	public JButton jbtnHelp = null;

	public JButton jbtnPreloadedValues = null;

	/**
	 * This is the default constructor
	 */
	public TopPanel() {
		super();
		initialize();
	}

	
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() 
	{
		this.setLayout(null);
		
		this.setVisible(true);
		this.setBounds(new Rectangle(0, 0, 943, 615));
		this.setBackground(Color.white);
		
        GLCapabilities caps = new GLCapabilities();
        caps.setDoubleBuffered(true);
        caps.setHardwareAccelerated(true);
        
		m_GraphControl = new GraphControl(caps);
		m_GraphControl.setBounds(new Rectangle(3, 16, 606, 293));
		m_GraphControl.setControlsEnabled(false);
		
        GLCapabilities caps2 = new GLCapabilities();
        caps2.setDoubleBuffered(true);
        caps2.setHardwareAccelerated(true);
        
		m_GraphControlFlow = new GraphControl(caps2);
		m_GraphControlFlow.setBounds(new Rectangle(3, 16, 606, 233));
		m_GraphControlFlow.setControlsEnabled(false);
		
	    this.add(getJpanelSimulatedChromatogram(), null);
	    this.add(getJpanelStep1(), null);
	    this.add(getJpanelStep2(), null);
	    this.add(getJpanelStep3(), null);
	    this.add(getJpanelStep4(), null);
	    this.add(getJpanelFlowProfile(), null);
	    this.add(getJbtnNextStep(), null);
	    this.add(getJbtnHelp(), null);
	    this.add(getJbtnPreloadedValues(), null);
   
	}

	public class JChemicalTable extends JTable
	{
		private static final long serialVersionUID = 1L;
		
		public JChemicalTable(DefaultTableModel tabModel) {
			super(tabModel);
		}

		public boolean isCellEditable(int row, int column)
		{
			return false;
		}
	}

	/**
	 * This method initializes jSimulatedChromatogram	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJpanelSimulatedChromatogram() 
	{
		if (jpanelSimulatedChromatogram == null) 
		{
			jpanelSimulatedChromatogram = new JPanel();
			jpanelSimulatedChromatogram.setLayout(null);
			jpanelSimulatedChromatogram.setBounds(new Rectangle(324, 0, 616, 313));
			jpanelSimulatedChromatogram.setBorder(BorderFactory.createTitledBorder(null, "Gradient Profile", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Dialog", Font.BOLD, 12), new Color(51, 51, 51)));
			jpanelSimulatedChromatogram.setBackground(Color.white);
			jpanelSimulatedChromatogram.setPreferredSize(new Dimension(615, 477));
			
			jpanelSimulatedChromatogram.add(m_GraphControl, null);
		}
		return jpanelSimulatedChromatogram;
	}

	/**
	 * This method initializes jpanelStep1	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJpanelStep1() {
		if (jpanelStep1 == null) {
			jLabel21 = new JLabel();
			jLabel21.setText("mL/min");
			jLabel21.setBounds(new Rectangle(256, 80, 48, 16));
			jlblFlowRate = new JLabel();
			jlblFlowRate.setText("Flow rate:");
			jlblFlowRate.setBounds(new Rectangle(8, 80, 185, 16));
			jlblFlowRate.setDisplayedMnemonic(KeyEvent.VK_UNDEFINED);
			jLabel2 = new JLabel();
			jLabel2.setText("min");
			jLabel2.setBounds(new Rectangle(256, 60, 49, 16));
			jLabel1 = new JLabel();
			jLabel1.setText("% B");
			jLabel1.setBounds(new Rectangle(256, 40, 49, 16));
			jLabel = new JLabel();
			jLabel.setText("% B");
			jLabel.setBounds(new Rectangle(256, 20, 49, 16));
			jlblGradientTime = new JLabel();
			jlblGradientTime.setText("Gradient time:");
			jlblGradientTime.setBounds(new Rectangle(8, 60, 185, 16));
			jlblGradientTime.setDisplayedMnemonic(KeyEvent.VK_UNDEFINED);
			jlblFinalSolventComposition = new JLabel();
			jlblFinalSolventComposition.setDisplayedMnemonic(KeyEvent.VK_UNDEFINED);
			jlblFinalSolventComposition.setBounds(new Rectangle(8, 40, 185, 16));
			jlblFinalSolventComposition.setText("Final solvent composition:");
			jlblInitialSolventComposition = new JLabel();
			jlblInitialSolventComposition.setText("Initial solvent composition:");
			jlblInitialSolventComposition.setBounds(new Rectangle(8, 20, 185, 16));
			jlblStationaryPhase = new JLabel();
			jlblStationaryPhase.setText("Standard column:");
			jlblStationaryPhase.setSize(new Dimension(105, 16));
			jlblStationaryPhase.setLocation(new Point(8, 24));
			jpanelStep1 = new JPanel();
			jpanelStep1.setLayout(null);
			jpanelStep1.setBounds(new Rectangle(0, 0, 317, 81));
			jpanelStep1.setBorder(BorderFactory.createTitledBorder(null, "Step #1: Select Standard Column", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Dialog", Font.BOLD, 12), new Color(51, 51, 51)));
			jpanelStep1.setBackground(Color.white);
			jpanelStep1.add(jlblStationaryPhase, null);
			jpanelStep1.add(getJcboStationaryPhase(), null);
		}
		return jpanelStep1;
	}


	/**
	 * This method initializes jcboStationaryPhase	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getJcboStationaryPhase() {
		if (jcboStationaryPhase == null) {
			jcboStationaryPhase = new JComboBox(Globals.StationaryPhaseArray);
			jcboStationaryPhase.setBounds(new Rectangle(8, 44, 297, 21));
		}
		return jcboStationaryPhase;
	}


	/**
	 * This method initializes jtxtInitialSolventComposition	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJtxtInitialSolventComposition() {
		if (jtxtInitialSolventComposition == null) {
			jtxtInitialSolventComposition = new JTextField();
			jtxtInitialSolventComposition.setBounds(new Rectangle(200, 18, 53, 20));
			jtxtInitialSolventComposition.setText("10.0");
		}
		return jtxtInitialSolventComposition;
	}


	/**
	 * This method initializes jtxtFinalSolventComposition	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJtxtFinalSolventComposition() {
		if (jtxtFinalSolventComposition == null) {
			jtxtFinalSolventComposition = new JTextField();
			jtxtFinalSolventComposition.setBounds(new Rectangle(200, 38, 53, 20));
			jtxtFinalSolventComposition.setText("100.0");
		}
		return jtxtFinalSolventComposition;
	}


	/**
	 * This method initializes jtxtGradientTime	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJtxtGradientTime() {
		if (jtxtGradientTime == null) {
			jtxtGradientTime = new JTextField();
			jtxtGradientTime.setBounds(new Rectangle(200, 58, 53, 20));
			jtxtGradientTime.setText("20.0");
		}
		return jtxtGradientTime;
	}


	/**
	 * This method initializes jtxtFlowRate	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getJtxtFlowRate() {
		if (jtxtFlowRate == null) {
			jtxtFlowRate = new JTextField();
			jtxtFlowRate.setBounds(new Rectangle(200, 78, 53, 20));
			jtxtFlowRate.setText("0.200");
		}
		return jtxtFlowRate;
	}


	/**
	 * This method initializes jpanelStep2	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJpanelStep2() {
		if (jpanelStep2 == null) {
			jpanelStep2 = new JPanel();
			jpanelStep2.setLayout(null);
			jpanelStep2.setBounds(new Rectangle(0, 84, 317, 109));
			jpanelStep2.setBorder(BorderFactory.createTitledBorder(null, "Step #2: Enter Approximate Gradient Conditions", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Dialog", Font.BOLD, 12), new Color(51, 51, 51)));
			jpanelStep2.setBackground(Color.white);
			jpanelStep2.add(jlblInitialSolventComposition, null);
			jpanelStep2.add(getJtxtInitialSolventComposition(), null);
			jpanelStep2.add(jLabel, null);
			jpanelStep2.add(jlblFinalSolventComposition, null);
			jpanelStep2.add(getJtxtFinalSolventComposition(), null);
			jpanelStep2.add(jLabel1, null);
			jpanelStep2.add(jlblGradientTime, null);
			jpanelStep2.add(getJtxtGradientTime(), null);
			jpanelStep2.add(jLabel2, null);
			jpanelStep2.add(jlblFlowRate, null);
			jpanelStep2.add(getJtxtFlowRate(), null);
			jpanelStep2.add(jLabel21, null);
		}
		return jpanelStep2;
	}


	/**
	 * This method initializes jpanelStep3	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJpanelStep3() {
		if (jpanelStep3 == null) {
			jpanelStep3 = new JPanel();
			jpanelStep3.setLayout(null);
			jpanelStep3.setBounds(new Rectangle(0, 196, 317, 205));
			jpanelStep3.setBorder(BorderFactory.createTitledBorder(null, "Step #3: Select Gradient Calibration Solutes", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Dialog", Font.BOLD, 12), new Color(51, 51, 51)));
			jpanelStep3.setBackground(Color.white);
			jpanelStep3.add(getJScrollPane(), null);
		}
		return jpanelStep3;
	}


	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setBounds(new Rectangle(8, 24, 301, 173));
			jScrollPane.setViewportView(getJTable());
		}
		return jScrollPane;
	}

    class SelectCompoundsTableModel extends AbstractTableModel {
		private String[] columnNames = {"Compound", "Select"};
        private Object[][] data = new Object[Globals.CompoundNameArray.length][2];
        
        public void loadData()
        {
        	for(int i=0; i < Globals.CompoundNameArray.length; i++)
            {
            	data[i][0] = Globals.CompoundNameArray[i];
            	data[i][1] = new Boolean(false);
            }
        }
        
        public int getColumnCount() {
            return columnNames.length;
        }

        public int getRowCount() {
            return data.length;
        }

        public String getColumnName(int col) {
            return columnNames[col];
        }

        public Object getValueAt(int row, int col) {
            return data[row][col];
        }

        /*
         * JTable uses this method to determine the default renderer/
         * editor for each cell.  If we didn't implement this method,
         * then the last column would contain text ("true"/"false"),
         * rather than a check box.
         */
        public Class getColumnClass(int c) {
            return getValueAt(0, c).getClass();
        }

        /*
         * Don't need to implement this method unless your table's
         * editable.
         */
        public boolean isCellEditable(int row, int col) {
            //Note that the data/cell address is constant,
            //no matter where the cell appears onscreen.
            if (col < 1) {
                return false;
            } else {
                return true;
            }
        }

        /*
         * Don't need to implement this method unless your table's
         * data can change.
         */
        public void setValueAt(Object value, int row, int col) {
            data[row][col] = value;
            fireTableCellUpdated(row, col);
        }
    }
        
	/**
	 * This method initializes jTable	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getJTable() {
		if (jTable == null)
		{
			Object[] columnNames = {"Compound", "Select"};
	        Object[][] data = new Object[Globals.CompoundNameArray.length][2];
	        for(int i=0; i < Globals.CompoundNameArray.length; i++)
            {
            	data[i][0] = Globals.CompoundNameArray[i];
            	data[i][1] = new Boolean(false);
            }
	        
			tmSelectCompounds = new SpecialTableModel(data, columnNames);
	        
			jTable = new JTable(tmSelectCompounds);
			jTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

			jTable.getTableHeader().setPreferredSize(new Dimension(jTable.getColumnModel().getTotalColumnWidth(), 22));
			jTable.getColumnModel().getColumn(0).setPreferredWidth(250);
		}
		return jTable;
	}


	/**
	 * This method initializes jpanelStep4	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJpanelStep4() {
		if (jpanelStep4 == null) {
			jpanelStep4 = new JPanel();
			jpanelStep4.setLayout(null);
			jpanelStep4.setBounds(new Rectangle(0, 404, 317, 209));
			jpanelStep4.setBorder(BorderFactory.createTitledBorder(null, "Step #4: Enter Their Measured Retention Times", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Dialog", Font.BOLD, 12), new Color(51, 51, 51)));
			jpanelStep4.setBackground(Color.white);
			jpanelStep4.add(getJScrollPane1(), null);
		}
		return jpanelStep4;
	}


	/**
	 * This method initializes jScrollPane1	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane1() {
		if (jScrollPane1 == null) {
			jScrollPane1 = new JScrollPane();
			jScrollPane1.setLocation(new Point(8, 20));
			jScrollPane1.setSize(new Dimension(301, 181));
			jScrollPane1.setViewportView(getJtableMeasuredRetentionTimes());
		}
		return jScrollPane1;
	}

	class SpecialTableModel extends DefaultTableModel 
	{
	    public SpecialTableModel(final Object[] columnNames, final int rowCount) 
	    {
	        super(convertToVector(columnNames), rowCount);
	    }
	    
	    public SpecialTableModel(final Object[][] data, final Object[] columnNames) 
	    {
	        setDataVector(data, columnNames);
	    }

	    public boolean isCellEditable(int row, int column) 
	    {
	        //Note that the data/cell address is constant,
	        //no matter where the cell appears onscreen.
	        if (column < 1) {
	            return false;
	        } else {
	            return true;
	        }
	    }
	    
	    /*
	     * JTable uses this method to determine the default renderer/
	     * editor for each cell.  If we didn't implement this method,
	     * then the last column would contain text ("true"/"false"),
	     * rather than a check box.
	     */
	    public Class getColumnClass(int c) {
	        return getValueAt(0, c).getClass();
	    }

	}
	
	/**
	 * This method initializes jtableMeasuredRetentionTimes	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getJtableMeasuredRetentionTimes() {
		if (jtableMeasuredRetentionTimes == null) 
		{
			Object[] columnNames = {"Compound", "tR (min)"};
			tmMeasuredRetentionTimes = new SpecialTableModel(columnNames, 0);

			jtableMeasuredRetentionTimes = new JTable(tmMeasuredRetentionTimes);

			jtableMeasuredRetentionTimes.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);

			jtableMeasuredRetentionTimes.getTableHeader().setPreferredSize(new Dimension(jTable.getColumnModel().getTotalColumnWidth(), 22));
			jtableMeasuredRetentionTimes.getColumnModel().getColumn(0).setPreferredWidth(250);
		}
		return jtableMeasuredRetentionTimes;
	}


	/**
	 * This method initializes jpanelFlowProfile	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJpanelFlowProfile() {
		if (jpanelFlowProfile == null) {
			jpanelFlowProfile = new JPanel();
			jpanelFlowProfile.setLayout(null);
			jpanelFlowProfile.setBounds(new Rectangle(324, 316, 615, 253));
			jpanelFlowProfile.setBackground(Color.white);
			jpanelFlowProfile.setPreferredSize(new Dimension(615, 477));
			jpanelFlowProfile.setBorder(BorderFactory.createTitledBorder(null, "Flow Rate Profile", TitledBorder.DEFAULT_JUSTIFICATION, TitledBorder.DEFAULT_POSITION, new Font("Dialog", Font.BOLD, 12), new Color(51, 51, 51)));
			jpanelFlowProfile.add(m_GraphControlFlow, null);
		}
		return jpanelFlowProfile;
	}


	/**
	 * This method initializes jbtnNextStep	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbtnNextStep() {
		if (jbtnNextStep == null) {
			jbtnNextStep = new JButton();
			jbtnNextStep.setText("Next Step  ");
			jbtnNextStep.setIcon(new ImageIcon(getClass().getResource("/org/retentionprediction/images/forward.png")));
			jbtnNextStep.setHorizontalTextPosition(SwingConstants.LEADING);
			jbtnNextStep.setHorizontalAlignment(SwingConstants.CENTER);
			jbtnNextStep.setLocation(new Point(760, 576));
			jbtnNextStep.setSize(new Dimension(178, 34));
			jbtnNextStep.setEnabled(false);
			jbtnNextStep.setActionCommand("Next Step");
		}
		return jbtnNextStep;
	}


	/**
	 * This method initializes jbtnHelp	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbtnHelp() {
		if (jbtnHelp == null) {
			jbtnHelp = new JButton();
			jbtnHelp.setText("Help");
			jbtnHelp.setLocation(new Point(572, 576));
			jbtnHelp.setSize(new Dimension(178, 34));
			jbtnHelp.setForeground(Color.blue);
		}
		return jbtnHelp;
	}


	/**
	 * This method initializes jbtnPreloadedValues	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getJbtnPreloadedValues() {
		if (jbtnPreloadedValues == null) {
			jbtnPreloadedValues = new JButton();
			jbtnPreloadedValues.setHorizontalAlignment(SwingConstants.CENTER);
			jbtnPreloadedValues.setHorizontalTextPosition(SwingConstants.LEADING);
			jbtnPreloadedValues.setText("Use Preloaded Values...");
			jbtnPreloadedValues.setLocation(new Point(324, 576));
			jbtnPreloadedValues.setSize(new Dimension(178, 34));
			jbtnPreloadedValues.setActionCommand("Preloaded Values");
		}
		return jbtnPreloadedValues;
	}
	
}  //  @jve:decl-index=0:visual-constraint="-259,126"
